<?php
require_once 'vendor/autoload.php';

use Appwrite\Client;
use Appwrite\Services\Databases;
use Appwrite\ID;

$client = new Client();

echo "<h1>Hello World! v2. </h1>";

try {

    echo "<br><h3>client.</h3>";

    $client
        ->setEndpoint('https://cloud.appwrite.io/v1')
        ->setProject('679e9f61002e5ffb671b')
        ->setKey('standard_64bbf12c87aee29bfddd6c9e628a36a18aadd35610fc12039ac881fcea899958ec05d1f2822188a65f9ce2cf339e17849666915db27aed0886348672d580646c678545fc9e81c4e63639843a6005e09466ab06149f7cd101bec6a44d03f830c7fa01255382883f5168e7a53a2d4ca2c5a68ea4b9c02194318203f4f8f347fb3b');

} catch (Exception $e) {
    echo 'client | Caught exception: ', $e->getMessage(), "\n";
    error_log('Client');
    echo "<h1>Client error. </h1>";
}


try {

    echo "<br><h3>databases.</h3>";
    $databases = new Databases($client);

} catch (Exception $e) {
    echo ' databases | Caught exception: ', $e->getMessage(), "\n";
    error_log('database');
    echo "<h1>database error. </h1>";
}


try {

    echo "<br><h3>prepareDatabase.</h3>";
    function prepareDatabase($databases)
    {

        $todoDatabase = $databases->create(
            databaseId: ID::unique(),
            name: 'TodosDB'
        );

        $todoCollection = $databases->createCollection(
            databaseId: $todoDatabase['$id'],
            collectionId: ID::unique(),
            name: 'Todos'
        );


        $databases->createStringAttribute(
            databaseId: $todoDatabase['$id'],
            collectionId: $todoCollection['$id'],
            key: 'title',
            size: 255,
            required: true
        );

        $databases->createStringAttribute(
            databaseId: $todoDatabase['$id'],
            collectionId: $todoCollection['$id'],
            key: 'description',
            size: 255,
            required: false,
        );

        $databases->createBooleanAttribute(
            databaseId: $todoDatabase['$id'],
            collectionId: $todoCollection['$id'],
            key: 'isComplete',
            required: true
        );

        return [$todoDatabase, $todoCollection];
    }

    //prepareDatabase($databases);

} catch (Exception $e) {
    echo 'PreparedDatabase | Caught exception: ', $e->getMessage(), "\n";
    error_log('PreparedDatabase');
    echo "<h1>PreparedDatabase. </h1>";
}

try {

    echo "<br><h3>seedDatabase 10.</h3>";

    function seedDatabase($databases)
    {
        $testTodo1 = [
            'title' => 'Buy apples',
            'description' => 'At least 2KGs',
            'isComplete' => true
        ];

        $testTodo2 = [
            'title' => 'Wash the apples',
            'isComplete' => true
        ];

        $testTodo3 = [
            'title' => 'Cut the apples',
            'description' => 'Don\'t forget to pack them in a box',
            'isComplete' => false
        ];

        $data = $testTodo1;

        $databases->createDocument(
            '679ed10733630800210f',
            '679ed1086492e01a472d',
            ID::unique(),
            $data,
            $permissions = null

        );


    }

    //string $databaseId, 
    //string $collectionId, 
    //string $documentId, 
    //array $data, 
    //array $permissions = null

    $todoCollection = '679ed1086492e01a472d';

    seedDatabase($databases);

    //FUNCTION SKELETION ENDS
    //seedDatabase($databases,$todoDatabase,$todoCollection);





} catch (Exception $e) {
    echo 'SeedDatabase| Caught exception: ', $e->getMessage(), "\n";
    error_log('SeedDatabase');
    echo "<h1>Seed Database 2 </h1>";

}



