<?php
namespace Appwrite;

class InputFile
{
    private ?string $data;
    private ?string $mimeType;
    private ?string $filename;
    private ?string $path;

    public function __construct()
    {
    }

    public function getData(): ?string
    {
        return $this->data;
    }

    public function getPath(): ?string
    {
        return $this->path;
    }

    public function getMimeType(): ?string
    {
        return $this->mimeType;
    }

    public function getFilename(): ?string
    {
        return $this->filename;
    }

    public static function withPath(string $path, ?string $mimeType = null, ?string $filename = null)
    {
        $instance = new InputFile();
        $instance->path = $path;
        $instance->data = null;
        $instance->mimeType = $mimeType;
        $instance->filename = $filename;
        return $instance;
    }

    public static function withData(string $data, ?string $mimeType = null, ?string $filename = null)
    {
        $instance = new InputFile();
        $instance->path = null;
        $instance->data = $data;
        $instance->mimeType = $mimeType;
        $instance->filename = $filename;
        return $instance;
    }
}